#include "StdAfx.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "math.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//###########################################################
//UINT PadMath(CPoint point)  
//This function is calculate where the mouse's left button down 
//Where=?                                     
//               ##############     
//          0   ##      3      ##  0
//             #  #           #  # 
//            #   #############   #
//           #     ##       ##     #
//           #  2  #    1    #  4  #           
//           #     ##       ##     # 
//            #   #############   #
//             # #            #  #
//              ##      5      ##
//          0     #############    0   
//
// return  UINT Where Value to tell programmer
// Then must call the PadDraw() to change the Picture
//##########################################################


UINT CControlDlg::PadMath(CPoint point)
{
   double pi=3.1415926535;
   double xp1,yp1,xp2,yp2,xp3,yp3,xp4,yp4;
   double px[8],py[8];
   POINT  pright[4],pleft[4],pup[4],pdown[4];//for Polygon region
   UINT cx,cy; // center x and y point
   UINT width,height;
   UINT length,length2,distance_x,distance_y; //distance between pad and dialog box left-up point
   UINT Where=0;
       
   CRect rect,m_rectEllipse,rect2,rect3;
   CRgn rgn0,rgn1,rgn2,rgn3,rgn4,rgn5;//for remembered calculate regions in pad
   
      
   GetDlgItem(IDC_PAD)->GetClientRect(rect);
   
   
   GetWindowRect(rect2);
   GetDlgItem(IDC_PAD)->GetWindowRect(rect3);
   
   width=rect.Width();
   height=rect.Height();
  
   cx=rect.right/2;
   cy=rect.bottom/2;
      
   length=(UINT)(width/2*0.92);

   length2=(UINT)(width);
   
   
   yp1=sin((double)( 45)*pi/2/90)*length;
   xp1=cos((double)( 45)*pi/2/90)*length;
   yp2=sin((double)(135)*pi/2/90)*length;
   xp2=cos((double)(135)*pi/2/90)*length;
  
   yp3=sin((double)(225)*pi/2/90)*length;
   xp3=cos((double)(225)*pi/2/90)*length;
   yp4=sin((double)(315)*pi/2/90)*length;
   xp4=cos((double)(315)*pi/2/90)*length;
  
//---------------------------------------------------
//           [6]--------------[7]  Polygon region
//           | \              / |
//           |  \            /  |
//           |   [2]------[3]   | 
//           |    |        |    | 
//           |    |        |    | 
//           |   [1]------[0]   |
//           |   /          \   |  
//           |  /            \  | 
//           [5]--------------[4] 
//
//----------------------------------------------------

   py[0]=sin((double)( 45)*pi/2/90)*19;
   px[0]=cos((double)( 45)*pi/2/90)*19;
   py[1]=sin((double)(135)*pi/2/90)*19;
   px[1]=cos((double)(135)*pi/2/90)*19;

   py[2]=sin((double)(225)*pi/2/90)*19;
   px[2]=cos((double)(225)*pi/2/90)*19;
   py[3]=sin((double)(315)*pi/2/90)*19;
   px[3]=cos((double)(315)*pi/2/90)*19;


   py[4]=sin((double)(45 )*pi/2/90)*length2;
   px[4]=cos((double)(45 )*pi/2/90)*length2;
   py[5]=sin((double)(135)*pi/2/90)*length2;
   px[5]=cos((double)(135)*pi/2/90)*length2;

   py[6]=sin((double)(225)*pi/2/90)*length2;
   px[6]=cos((double)(225)*pi/2/90)*length2;
   py[7]=sin((double)(315)*pi/2/90)*length2;
   px[7]=cos((double)(315)*pi/2/90)*length2;

    pright[0].x=(int)px[0]+cx;//calculate right button region points         
   	pright[0].y=(int)py[0]+cy;            
    pright[1].x=(int)px[3]+cx;       
   	pright[1].y=(int)py[3]+cy;        
    pright[2].x=(int)px[7]+cx;       
   	pright[2].y=(int)py[7]+cy;       
    pright[3].x=(int)px[4]+cx;
   	pright[3].y=(int)py[4]+cy;

    pleft[0].x=(int)px[1]+cx;//calculate left button region points
   	pleft[0].y=(int)py[1]+cy;
    pleft[1].x=(int)px[2]+cx;
   	pleft[1].y=(int)py[2]+cy;
    pleft[2].x=(int)px[6]+cx;
   	pleft[2].y=(int)py[6]+cy;
    pleft[3].x=(int)px[5]+cx;
   	pleft[3].y=(int)py[5]+cy;

    pup[0].x=(int)px[2]+cx;//calculate up button region points
   	pup[0].y=(int)py[2]+cy;
    pup[1].x=(int)px[3]+cx;
   	pup[1].y=(int)py[3]+cy;
    pup[2].x=(int)px[7]+cx;
   	pup[2].y=(int)py[7]+cy;
    pup[3].x=(int)px[6]+cx;
   	pup[3].y=(int)py[6]+cy;

    
	pdown[0].x=(int)px[0]+cx;//calculate down button region points
   	pdown[0].y=(int)py[0]+cy;
    pdown[1].x=(int)px[1]+cx;
   	pdown[1].y=(int)py[1]+cy;
	pdown[2].x=(int)px[5]+cx;
   	pdown[2].y=(int)py[5]+cy;
    pdown[3].x=(int)px[4]+cx;
   	pdown[3].y=(int)py[4]+cy;

 distance_x=rect3.left-rect2.left;  //distance between pad and dialog box left-up point

 distance_y=rect3.top  -rect2.top;
   
    point.x-=distance_x;
    point.y-=distance_y;
   
  m_rectEllipse.SetRect(cx-length,cy-length,cx+length,cy+length);
  rgn0.CreateEllipticRgnIndirect(m_rectEllipse);
  if(rgn0.PtInRegion(point))
  {
 	  
     rgn2.CreatePolygonRgn(pleft,4,WINDING);
 	 if(rgn2.PtInRegion(point))
	 {
     Where=2;     //---left button pushed down
	 }
 	
     rgn3.CreatePolygonRgn(pup,4,WINDING);
 	 if(rgn3.PtInRegion(point))
	 {
     Where=3;     //---up button pushed down
	 }
 	
     rgn4.CreatePolygonRgn(pright,4,WINDING);
 	 if(rgn4.PtInRegion(point))
	 {
     Where=4;     //---right button pushed down
	 }
 	 
	 rgn5.CreatePolygonRgn(pdown,4,WINDING);
 	 if(rgn5.PtInRegion(point))
	 {
     Where=5;     //---down button pushed down
	 }

	 m_rectEllipse.SetRect(cx-18,cy-18,cx+18,cy+18);
     rgn1.CreateEllipticRgnIndirect(m_rectEllipse);
     if(rgn1.PtInRegion(point))
	 {
       Where=1;   //---Manual(Stop) button pushed down
	 }

   }

   return  Where;
}

//##########################################################
//	PadDraw(UINT PADNum)
//  :change picture on pad(up,down,left,right,stop)
//  PADNum=0: pad   Nothing happened or all button up picture
//         1: manual(stop)  button pushed down picture
//         2: left   button pushed down picture
//         3: up     button pushed down picture
//         4: right  button pushed down picture
//         5: down   button pushed down picture
//##########################################################
void CControlDlg::PadDraw(UINT PADNum)
{
  
switch(PADNum)
	{
	case 0:  //-----All button up or nothing happened
		::SendDlgItemMessage(m_hWnd,IDC_PAD,
 			STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmapPAD );
		break;
	case 1:  //-----manual(stop) button pushed down picture
		::SendDlgItemMessage(m_hWnd,IDC_PAD,
 			STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmapPAD_STOP);
		break;
	case 2:  //-----left button pushed down picture
		::SendDlgItemMessage(m_hWnd,IDC_PAD,
     		STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmapPAD_LEFT );
		break;
	case 3:  //-----up button pushed down picture
		::SendDlgItemMessage(m_hWnd,IDC_PAD,
    		STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmapPAD_UP );
		break;
	case 4:  //-----right button pushed down picture
		::SendDlgItemMessage(m_hWnd,IDC_PAD,
			STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmapPAD_RIGHT );
		break;
   case 5:  //down buttton pushed down picture
		::SendDlgItemMessage(m_hWnd,IDC_PAD,
    		STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmapPAD_DOWN );
		break;

   }

}// end of PadDraw(UINT PADNum)




